const db = require("../db/db");

const getallreviews = () => {
  const sql = `SELECT * FROM reviews WHERE Status = 1`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const addReview = (
  Name,

  Feedback,
  Rating,

  Name_fr,

  Feedback_fr,

  Name_es,

  Feedback_es,

  Name_de,

  Feedback_de
) => {
  const sql = `
    INSERT INTO requests 
      (Name, Feedback,Rating,
       Name_fr, Feedback_fr, 
       Name_es, Feedback_es,
       Name_de, Feedback_de) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)
  `;
  const params = [
    Name,

    Feedback,
    Rating,

    Name_fr,

    Feedback_fr,

    Name_es,

    Feedback_es,

    Name_de,

    Feedback_de,
  ];

  return new Promise((resolve, reject) => {
    db.query(sql, params, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const getReviewById = (idReview) => {
  const sql = `SELECT * FROM reviews WHERE idReview = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idReview], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const updatebyid = (
  Name,
  Feedbacktopic,
  Feedback,
  Position,
  Email,
  idReview
) => {
  const sql = `UPDATE reviews SET Name = ?, Feedbacktopic = ?, Feedback = ?, Position = ?, Email = ? WHERE idReview = ?`;
  return new Promise((resolve, reject) => {
    db.query(
      sql,
      [Name, Feedbacktopic, Feedback, Position, Email, idReview],
      (err, results) => {
        if (err) {
          reject(err);
        } else {
          resolve(results);
        }
      }
    );
  });
};

const updateStatus = (idReview) => {
  const sql = `UPDATE reviews SET Status = CASE 
  WHEN Status = 1 THEN 0
  WHEN Status = 0 THEN 1
END 
WHERE idReview = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idReview], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const getAlltherev = () => {
  const sql = `SELECT * FROM reviews `;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const deleteReview = (idReview) => {
  const sql = `DELETE FROM reviews WHERE idReview = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idReview], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  getallreviews,
  addReview,
  getReviewById,
  updatebyid,
  updateStatus,
  getAlltherev,
  deleteReview,
};
