const db = require("../db/db");

// Get all locations
const getAllLocations = () => {
  const sql = `SELECT * FROM locations`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

// Add a new location
const addLocation = (Name) => {
  const sql = `INSERT INTO locations (Name) VALUES (?)`;
  return new Promise((resolve, reject) => {
    db.query(sql, [Name], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

// Get location by ID
const getLocationById = (idLocations) => {
  const sql = `SELECT * FROM locations WHERE idLocations = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idLocations], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

// Delete location by ID
const deleteLocation = (idLocations) => {
  const sql = `DELETE FROM locations WHERE idLocations = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idLocations], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  getAllLocations,
  addLocation,
  getLocationById,
  deleteLocation,
};
