const db = require("../db/db");
const { translateText } = require("../utils/translator");
const add = async (Title, Des, Package_idPackage) => {
  const Title_fr = await translateText(Title, "fr");
  const Title_es = await translateText(Title, "es");
  const Title_gr = await translateText(Title, "de");

  const Des_fr = await translateText(Des, "fr");
  const Des_es = await translateText(Des, "es");
  const Des_gr = await translateText(Des, "de");

  const sql = `INSERT INTO itinaries (Title,Des,Package_idPackage,Title_fr,Des_fr,Title_es,Des_es,Title_gr,Des_gr) VALUES (?,?,?,?,?,?,?,?,?)`;

  return new Promise((resolve, reject) => {
    db.query(
      sql,
      [
        Title,
        Des,
        Package_idPackage,
        Title_fr,
        Des_fr,
        Title_es,
        Des_es,
        Title_gr,
        Des_gr,
      ],
      (err, results) => {
        if (err) {
          reject(err);
        } else {
          resolve(results);
        }
      }
    );
  });
};

const edit = async (Title, Des, Package_idPackage, id) => {
  const Title_fr = await translateText(Title, "fr");
  const Title_es = await translateText(Title, "es");
  const Title_gr = await translateText(Title, "de");

  const Des_fr = await translateText(Des, "fr");
  const Des_es = await translateText(Des, "es");
  const Des_gr = await translateText(Des, "de");

  const sql = `UPDATE itinaries SET Title = ? ,Des = ?,Package_idPackage = ?,Title_fr = ?, Des_fr = ?,Title_es = ?, Des_es = ?, Title_gr = ?, Des_gr = ? WHERE idItinary = ?`;
  return new Promise((resolve, reject) => {
    db.query(
      sql,
      [
        Title,
        Des,
        Package_idPackage,
        Title_fr,
        Des_fr,
        Title_es,
        Des_es,
        Title_gr,
        Des_gr,
        id,
      ],
      (err, results) => {
        if (err) {
          reject(err);
        } else {
          resolve(results);
        }
      }
    );
  });
};

const getByPackageId = (Package_idPackage, lang) => {
  let titleField = "Title";
  let desField = "Des";

  if (["fr", "es", "gr"].includes(lang)) {
    titleField = `Title_${lang}`;
    desField = `Des_${lang}`;
  }

  const sql = `
    SELECT 
      idItinary,
      ${titleField} AS Title,
      ${desField} AS Des,
      Package_idPackage
    FROM itinaries 
    WHERE Package_idPackage = ?
  `;

  return new Promise((resolve, reject) => {
    db.query(sql, [Package_idPackage], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const getAll = () => {
  const sql = `SELECT * FROM itinaries`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const deleteit = (id) => {
  const sql = `DELETE FROM itinaries WHERE idItinary = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [id], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const getAllDaysOfForFilter = () => {
  const sql = `SELECT DISTINCT NoDays FROM packages WHERE NoDays IS NOT NULL ORDER BY NoDays ASC`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  add,
  getByPackageId,
  edit,
  getAll,
  deleteit,
  getAllDaysOfForFilter,
};
