const express = require("express");
const cors = require("cors");
const app = express();
const port = 8000;
const db = require("./db/db");
const cookieParser = require("cookie-parser");

// ✅ Skip body parser for multipart/form-data
app.use((req, res, next) => {
  const contentType = req.headers["content-type"] || "";
  if (contentType.startsWith("multipart/form-data")) {
    next(); // Let multer handle it
  } else {
    express.json({ limit: "350mb" })(req, res, (err) => {
      if (err) return next(err);
      express.urlencoded({ limit: "350mb", extended: true })(req, res, next);
    });
  }
});

// ✅ CORS
const corsOptions = {
  methods: ["GET", "POST", "PUT", "DELETE"],
};
app.use(cors(corsOptions));

// ✅ Cookies and static files
app.use(cookieParser());
app.use("/package-upload", express.static("packages"));
app.use("/accommodation-upload", express.static("accomadation"));
app.use("/event-upload", express.static("events"));
app.use("/gallery-upload", express.static("gallery"));
app.use("/package-category-upload", express.static("packagecategory"));
app.use("/memory-images", express.static("memory"));
app.use("/upload", express.static("upload"));
app.use("/package-category-hero", express.static("packagecategoryheroimages"));
// ✅ Routes
const authenticationRoutes = require("./routes/authRoutes");
const packageRoutes = require("./routes/packageRoutes");
const requestRoutes = require("./routes/requestRoutes");
const locationRoutes = require("./routes/locationRoutes");
const contactusRoutes = require("./routes/contactusRoutes");
const accomadationRoutes = require("./routes/accomadationRoutes");
const videoRoutes = require("./routes/videoRoutes");
const eventRoutes = require("./routes/eventRoutes");
const galleryRoutes = require("./routes/galleryRoutes");
const messageRequestRoutes = require("./routes/messageRequestRoutes");
const packageCategoryRoutes = require("./routes/packageCategoryRoutes");
const pageHideRoutes = require("./routes/pagehideRoutes");
const qaRoutes = require("./routes/qaRoutes");
const newsRoutes = require("./routes/addNewsRoutes");
const reviewRoutes = require("./routes/reviewRoutes");
const memoRoutes = require("./routes/memoryRoutes");
const itinaryRoutes = require("./routes/itinariesRoutes");

const blogCategoryRoutes = require("./routes/blogCategoryRoutes");
app.use(express.urlencoded({ extended: true }));
app.use(express.json());

app.use("/api/authentication", authenticationRoutes);
app.use("/api/packages", packageRoutes);
app.use("/api/requests", requestRoutes);
app.use("/api/locations", locationRoutes);
app.use("/api/contactus", contactusRoutes);
app.use("/api/accomadation", accomadationRoutes);
app.use("/api/video", videoRoutes);
app.use("/api/events", eventRoutes);
app.use("/api/gallery", galleryRoutes);
app.use("/api/message-request", messageRequestRoutes);
app.use("/api/package-category", packageCategoryRoutes);
app.use("/api/page-hide", pageHideRoutes);
app.use("/api/qa", qaRoutes);
app.use("/api/blog-category", blogCategoryRoutes);
app.use("/api/add-newsletter", newsRoutes);
app.use("/api/review", reviewRoutes);
app.use("/api/memory", memoRoutes);
app.use("/api/itinaries", itinaryRoutes);
// ✅ Start the server
app.listen(port, () => {
  console.log("Express backend is working on port number 8000!");
});
