const express = require("express");
const router = express.Router();

const {
  getAllRequests,
  addReq,
  deleteReq,
  getByid,
  changeStatus,
  getActiveRequests,
} = require("../controllers/requestController");
router.get("/get-active-requests/:lang", getActiveRequests);
router.get("/", getAllRequests);
router.get("/:idRequests", getByid);
router.post("/", addReq);
router.delete("/:idRequests", deleteReq);
router.put("/:idRequests", changeStatus);

module.exports = router;
