const reviewDbService = require("../services/reviewDbService");
const { translateText } = require("../utils/translator");
const nodemailer = require("nodemailer");
const getallreviews = async (req, res) => {
  try {
    const data = await reviewDbService.getallreviews();

    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when fetching details!",
      error: err.message,
    });
  }
};

const addReview = async (req, res) => {
  try {
    const { Name, Feedback, Rating } = req.body;

    const langs = ["fr", "es", "gr"];

    const translations = await Promise.all(
      langs.map(async (lang) => ({
        lang,
        Name: await translateText(Name, lang),
        Feedback: await translateText(Feedback, lang),
      }))
    );

    const fr = translations.find((t) => t.lang === "fr");
    const es = translations.find((t) => t.lang === "es");
    const de = translations.find((t) => t.lang === "gr");

    await reviewDbService.addReview(
      Name,
      Feedback,
      Rating,
      fr.Name,
      fr.Feedback,
      es.Name,
      es.Feedback,
      de.Name,
      de.Feedback
    );

    res.status(201).json({ message: "Review added with translations!" });
  } catch (err) {
    console.error(err);
    res.status(500).json({
      Status: "Something went wrong when adding the review!",
      error: err.message,
    });
  }
};

const getReviewById = async (req, res) => {
  try {
    const { idReview } = req.params;
    const data = await reviewDbService.getReviewById(idReview);
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when fetching details!",
      error: err.message,
    });
  }
};

const updatebyid = async (req, res) => {
  try {
    const { idReview } = req.params;
    const { Name, Feedbacktopic, Feedback, Position, Email } = req.body;

    await reviewDbService.updatebyid(
      Name,
      Feedbacktopic,
      Feedback,
      Position,
      Email,
      idReview
    );
    res.status(201).json({ message: "updating completed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating details!",
      error: err.message,
    });
  }
};

const updateStatus = async (req, res) => {
  try {
    const { idReview } = req.params;
    const updation = await reviewDbService.updateStatus(idReview);
    res.status(200).json({ message: "Status changed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating details!",
      error: err.message,
    });
  }
};
const getAlltherev = async (req, res) => {
  try {
    const data = await reviewDbService.getAlltherev();
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating details!",
      error: err.message,
    });
  }
};
const deleteReview = async (req, res) => {
  try {
    const { idReview } = req.params;
    await reviewDbService.deleteReview(idReview);
    res.status(201).json({ message: "Deletion completed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating details!",
      error: err.message,
    });
  }
};
module.exports = {
  getallreviews,
  addReview,
  getReviewById,
  updatebyid,
  updateStatus,
  getAlltherev,
  deleteReview,
};
