const db = require("../db/db");

const getAllGallery = () => {
  const sql = `SELECT * FROM memory`;
  return new Promise((resolve, reject) => {
    db.query(sql, (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const addGalleryImages = (images) => {
  // images is an array of { filename }
  const sql = `INSERT INTO memory (Image) VALUES ?`;

  // Prepare the values array like: [[filename1], [filename2], ...]
  const values = images.map((img) => [img.filename]);

  return new Promise((resolve, reject) => {
    db.query(sql, [values], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

const deleteImage = (idGallery) => {
  const sql = `DELETE FROM memory WHERE idMemory = ?`;
  return new Promise((resolve, reject) => {
    db.query(sql, [idGallery], (err, results) => {
      if (err) {
        reject(err);
      } else {
        resolve(results);
      }
    });
  });
};

module.exports = {
  getAllGallery,
  addGalleryImages,
  deleteImage,
};
