const express = require("express");
const router = express.Router();

const {
  addPackage,
  getAllPackages,
  getPackageById,
  deletePackage,
  updatePackage,
  changePackageStatus,
  packageActiveFetch,
  packageActiveFetchByCategoryId,
  getActivePackagesByNoDays,
} = require("../controllers/packageController");
const uploadMiddleware = require("../middleware/uploadMiddleware");
router.get("/packages-active", packageActiveFetch);
router.get(
  "/package-active-by-category/:PackageCategory_idPackageCategory/:lang",
  packageActiveFetchByCategoryId
);
router.post("/", uploadMiddleware.array("Image"), addPackage);
router.get("/", getAllPackages);
router.get("/:idPackage", getPackageById);
router.delete("/:idPackage", deletePackage);
router.put("/:idPackage", uploadMiddleware.array("Image"), updatePackage);
router.put("/change-status/:idPackage", changePackageStatus);
router.get(
  "/package-active-by-nodays/:NoDays/:lang",
  getActivePackagesByNoDays
);
module.exports = router;
