const express = require("express");
const router = express.Router();

const {
  add,
  update,
  remove,
  getById,
  getAll,
  getPackageCategoryByLang,
  getPackageCategoryIDByLang,
} = require("../controllers/packageCategoryController");

const packageCategoryMiddleware = require("../middleware/packageCategoryMiddleware");

router.get(
  "/get-package-category-by-id-lang/:idPackageCategory/:lang",
  getPackageCategoryIDByLang
);
router.get("/", getAll);
router.get("/:id", getById);
router.post(
  "/",
  packageCategoryMiddleware.fields([
    { name: "Image", maxCount: 1 },
    { name: "Image2", maxCount: 1 },
  ]),
  add
);
router.delete("/:id", remove);
router.put(
  "/:id",
  packageCategoryMiddleware.fields([
    { name: "Image", maxCount: 1 },
    { name: "Image2", maxCount: 1 },
  ]),
  update
);
router.get("/get-by-lang/:lang", getPackageCategoryByLang);
module.exports = router;
