const express = require("express");
const router = express.Router();

const {
  getAllEvents,
  addEvent,
  getEventById,
  updateEventById,
  deleteEvent,
  getEventByLang,
} = require("../controllers/eventsController");
const uploadMiddleware = require("../middleware/eventMiddleware");

router.post("/", uploadMiddleware.single("Image"), addEvent);
router.get("/", getAllEvents);
router.get("/:idEvent", getEventById);
router.delete("/:idEvent", deleteEvent);
router.put("/:idEvent", uploadMiddleware.single("Image"), updateEventById);
router.get("/get-by-lang/:lang", getEventByLang);

module.exports = router;
