const express = require("express");
const router = express.Router();

const {
  addAccommodation,
  getAllAccommodations,
  getAccommodationById,
  updateAccommodation,
  deleteAccommodation,getAccomadationByLocId
} = require("../controllers/accomadationController");
const uploadMiddleware = require("../middleware/accomadationMiddleware");

router.post("/", uploadMiddleware.single("Image"), addAccommodation);
router.get("/", getAllAccommodations);
router.get("/:idAccommodation", getAccommodationById);
router.delete("/:idAccommodation", deleteAccommodation);
router.put(
  "/:idAccommodation",
  uploadMiddleware.single("Image"),
  updateAccommodation
);
router.get("/get-accomadation-by-location/:id",getAccomadationByLocId)

module.exports = router;
