const multer = require("multer");
const path = require("path");
const fs = require("fs");

// Dynamically set destination based on fieldname
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    let folder = "";

    if (file.fieldname === "Image") {
      folder = "packagecategory/";
    } else if (file.fieldname === "Image2") {
      folder = "packagecategoryheroimages/";
    }

    // Ensure directory exists
    fs.mkdirSync(folder, { recursive: true });
    cb(null, folder);
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname));
  },
});

const uploadMiddleware = multer({ storage: storage });

module.exports = uploadMiddleware;
