const qaDbService = require("../services/qaDbService");

const add = async (req, res) => {
  try {
    const { Question, Answer } = req.body;

    await qaDbService.add(Question, Answer);
    res.status(201).json({ success: true, message: "QA adding completed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when deleting event!",
      error: err.message,
    });
  }
};

const getAll = async (req, res) => {
  try {
    const data = await qaDbService.getAll();
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when deleting event!",
      error: err.message,
    });
  }
};

const update = async (req, res) => {
  try {
    const { idQa } = req.params;
    const { Question, Answer } = req.body;
    await qaDbService.update(idQa, Question, Answer);
    res
      .status(200)
      .json({ success: true, message: "QA updated successfully!" });
  } catch (err) {
    res.status(500).json({
      Status: "Failed to update QA!",
      error: err.message,
    });
  }
};

const remove = async (req, res) => {
  try {
    const { idQa } = req.params;
    await qaDbService.remove(idQa);
    res
      .status(200)
      .json({ success: true, message: "QA deleted successfully!" });
  } catch (err) {
    res.status(500).json({
      Status: "Failed to delete QA!",
      error: err.message,
    });
  }
};

const getByLang = async (req, res) => {
  try {
    const { lang } = req.params;
    const data = await qaDbService.getByLang(lang);
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Failed to delete QA!",
      error: err.message,
    });
  }
};
module.exports = {
  add,
  getAll,
  update,
  getByLang,
  remove,
};
