const pagehideDbService = require("../services/pagehideDbService");

const getPagesForLang = async (req, res) => {
  try {
    const { lang } = req.params;
    const data = await pagehideDbService.getAllPagesByLang(lang);
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating event!",
      error: err.message,
    });
  }
};

const getAllPages = async (req, res) => {
  try {
    const data = await pagehideDbService.getAllPages();
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating event!",
      error: err.message,
    });
  }
};

const getallAdmin = async (req, res) => {
  try {
    const data = await pagehideDbService.getallAdmin();
    res.status(201).json(data);
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating event!",
      error: err.message,
    });
  }
};

const changeStatus = async (req, res) => {
  try {
    const { idPagehide } = req.params;
    await pagehideDbService.changeStatus(idPagehide);
    res.status(201).json({ success: true, message: "Status changed!" });
  } catch (err) {
    res.status(500).json({
      Status: "Something went wrong when updating event!",
      error: err.message,
    });
  }
};

module.exports = {
  getAllPages,
  changeStatus,
  getallAdmin,
  getPagesForLang,
};
