const ItinariesDbService = require("../services/itinariesDbService");

const add = async (req, res) => {
  try {
    const { Title, Des, Package_idPackage } = req.body;

    await ItinariesDbService.add(Title, Des, Package_idPackage);
    res.status(201).json({ message: "adding completed!", success: true });
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when adding event!",
      error: err.message,
    });
  }
};

const getAll = async (req, res) => {
  try {
    const data = await ItinariesDbService.getAll();
    res.status(201).json(data);
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when adding event!",
      error: err.message,
    });
  }
};

const getByPackageId = async (req, res) => {
  try {
    const { id, lang } = req.params;

    const itineraries = await ItinariesDbService.getByPackageId(id, lang);
    res.status(200).json(itineraries);
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when fetching itineraries!",
      error: err.message,
    });
  }
};

const edit = async (req, res) => {
  try {
    const { id } = req.params;
    const { Title, Des, Package_idPackage } = req.body;
    await ItinariesDbService.edit(Title, Des, Package_idPackage, id);
    res.status(201).json({ message: "Updating completed!", success: true });
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when fetching itineraries!",
      error: err.message,
    });
  }
};

const deleteit = async (req, res) => {
  try {
    const { id } = req.params;
    await ItinariesDbService.deleteit(id);
    res.status(201).json({ message: "Deleting completed!", success: true });
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when fetching itineraries!",
      error: err.message,
    });
  }
};

const getAllDaysOfForFilter = async (req, res) => {
  try {
    const data = await ItinariesDbService.getAllDaysOfForFilter();
    res.status(200).json(data);
  } catch (err) {
    console.log(err);
    res.status(500).json({
      Status: "Something went wrong when fetching itineraries!",
      error: err.message,
    });
  }
};

module.exports = {
  add,
  getByPackageId,
  edit,
  getAll,
  deleteit,
  getAllDaysOfForFilter,
};
