const blogCategoryDbService = require("../services/blogCategoryDbService");

// Add blog category
const add = async (req, res) => {
  try {
    const { Name } = req.body;
    await blogCategoryDbService.add(Name);
    res
      .status(201)
      .json({ success: true, message: "Blog category added successfully!" });
  } catch (err) {
    res.status(500).json({
      status: "Error adding blog category",
      error: err.message,
    });
  }
};

// Delete blog category
const remove = async (req, res) => {
  try {
    const { idBlogCategory } = req.params;
    await blogCategoryDbService.remove(idBlogCategory);
    res
      .status(200)
      .json({ success: true, message: "Blog category deleted successfully!" });
  } catch (err) {
    res.status(500).json({
      status: "Error deleting blog category",
      error: err.message,
    });
  }
};

const getAll = async (req, res) => {
  try {
    const data = await blogCategoryDbService.getAll();
    res.status(200).json(data);
  } catch (err) {
    res.status(500).json({
      status: "Error retrieving blog categories",
      error: err.message,
    });
  }
};

// Optional: Update blog category
const update = async (req, res) => {
  try {
    const { idBlogCategory } = req.params;
    const { Name } = req.body;
    await blogCategoryDbService.update(idBlogCategory, Name);
    res
      .status(200)
      .json({ success: true, message: "Blog category updated successfully!" });
  } catch (err) {
    res.status(500).json({
      status: "Error updating blog category",
      error: err.message,
    });
  }
};

const getbylang = async (req, res) => {
  try {
    const { lang } = req.params;
    const data = await blogCategoryDbService.getbylang(lang);
    res.status(200).json(data);
  } catch (err) {
    res.status(500).json({
      status: "Error retrieving blog categories",
      error: err.message,
    });
  }
};

module.exports = {
  add,
  remove,
  getAll,
  update,
  getbylang,
};
